# Copyright 2017, 2019, Oracle Corporation and/or affiliates.  All rights reserved.
# Licensed under the Universal Permissive License v 1.0 as shown at http://oss.oracle.com/licenses/upl

resource "null_resource" "sdb_standby_shard_env_configure" {
 count = "${var.setup_mode == "new_install" ? 0 : length(var.standby_shards)}"

  #creates ssh connection 
  connection {
    type = "ssh"
    user = "${var.os_user}"
    private_key = "${file(var.ssh_private_key_path)}"
    host = "${lookup(var.standby_shards[element(keys(var.standby_shards), count.index)], "host")}"
    agent = false
    timeout = "${var.ssh_timeout}"
  } 

  # copying env
  provisioner "file" {  
    content  = <<-EOF
        #! /bin/bash
        export ORACLE_SID="${lookup(var.standby_shards[element(keys(var.standby_shards), count.index)], "sid")}"
        export ORACLE_BASE="${var.oracle_base}"
        export ORACLE_HOME="${var.db_home_path}"
        export LD_LIBRARY_PATH=$ORACLE_HOME/lib
        export PATH=$PATH:$ORACLE_HOME/bin
        export TNS_ADMIN=$ORACLE_HOME/network/admin  
        EOF
    destination = "${var.db_home_path}/shard.sh"
  }
}